---
generated_at: 2026-01-20 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：1-Simply VB Unit Runner

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 全項目に根拠が確認できたため、優先レビュー項目はありません

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/Tests/frmSimplyVBUnitRunner.frm` 行1-4: フォーム定義（SimplyVBUnit.Component.ocx参照）
- E-02: `Source/Tests/frmSimplyVBUnitRunner.frm` 行3-4: Caption = "Simply VB Unit"
- E-03: `Source/Tests/frmSimplyVBUnitRunner.frm` 行15-32: UIRunner1コントロール定義
- E-04: `Source/Tests/frmSimplyVBUnitRunner.frm` 行55-70: Form_Load テストスイート追加処理
- E-05: `Source/Tests/frmSimplyVBUnitRunner.frm` 行398-401: Form_Initialize UIRunner初期化
- E-06: `Source/Tests/frmSimplyVBUnitRunner.frm` 行403-410: Form_KeyDown キー処理
- E-07: `Source/Tests/frmSimplyVBUnitRunner.frm` 行88-148: AddSystem メソッド
- E-08: `Source/Tests/frmSimplyVBUnitRunner.frm` 行150-189: AddSystemCollections メソッド
- E-09: `Source/Tests/frmSimplyVBUnitRunner.frm` 行191-245: AddSystemSecurityCryptography メソッド
- E-10: `Source/Tests/frmSimplyVBUnitRunner.frm` 行247-273: AddSystemResources メソッド
- E-11: `Source/Tests/frmSimplyVBUnitRunner.frm` 行275-297: AddSystemIO メソッド
- E-12: `Source/Tests/frmSimplyVBUnitRunner.frm` 行56: SkipUnsupportedTimeZone = False
- E-13: `docs/code-to-docs/画面一覧/画面一覧.csv` 行2: 画面情報定義
- E-14: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 行2-44: 機能マッピング情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SimplyVBUnit.Component.ocxを使用 | E-01 | ○ |
| C-02 | 画面タイトルは"Simply VB Unit" | E-02 | ○ |
| C-03 | UIRunner1コントロールでテスト結果を表示 | E-03 | ○ |
| C-04 | Form_Loadで複数のテストスイートを追加 | E-04 | ○ |
| C-05 | Form_InitializeでUIRunner初期化とOutputLogger追加 | E-05 | ○ |
| C-06 | F5キーでテスト実行、ESCキーで終了 | E-06 | ○ |
| C-07 | Systemカテゴリに基本型・例外・配列テスト含む | E-07 | ○ |
| C-08 | Collectionsカテゴリにリスト・ハッシュテーブル等のテスト含む | E-08 | ○ |
| C-09 | Cryptographyカテゴリに暗号化アルゴリズムテスト含む | E-09 | ○ |
| C-10 | Resourcesカテゴリにリソース管理テスト含む | E-10 | ○ |
| C-11 | IOカテゴリにファイル操作テスト含む | E-11 | ○ |
| C-12 | SkipUnsupportedTimeZoneフラグの存在 | E-12 | ○ |
| C-13 | 画面はテストカテゴリとして定義されている | E-13 | ○ |
| C-14 | 40以上の機能に関連するテストを実行 | E-14 | ○ |
| C-15 | KeyPreview = True でフォームがキー入力を受け取る | E-01 (行10) | ○ |
| C-16 | StartUpPosition = CenterScreen で画面中央に表示 | E-01 (行14) | ○ |
| C-17 | NewSuiteヘルパー関数でサブスイート作成 | E-07 (行114-121等) | ○ |
| C-18 | OutputLoggerリスナーを追加 | E-05 (行400) | ○ |

## 4) 不足情報（Unknown / Missing）
- 現時点で根拠なしの項目はありません
- OutputLogger.clsの実装詳細は確認していないが、フォームコードから参照されていることは確認済み

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコードの根拠あり

## 6) レビュアーチェックリスト（最小）
- [x] 全ての主張にソースコード根拠が対応している
- [ ] SimplyVBUnit.Component.ocxの外部依存が環境で利用可能か確認
- [ ] OutputLoggerクラスの実装内容を必要に応じて確認
